//
//  Constants.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/3/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRView;
@class CRLibraryManager;

//////////////////////////////////////////////////////////////////////
// Any model object that provides a view controller
//////////////////////////////////////////////////////////////////////
@protocol CREditing

- (BOOL)providesView;
- (Class)viewControllerClass;
- (NSViewController *)viewController;

@end

//////////////////////////////////////////////////////////////////////
// An object with some undoable parameters
//////////////////////////////////////////////////////////////////////
@protocol CRUndoable

- (NSArray *)paramsDescriptors;	// undo-relative keyPaths
- (NSArray *)dependedUndoables;	// sub-item paths with CRUndoable support
- (void)safeSetValue:(id)value forKeyPath:(NSString *)keyPath;

@end

//////////////////////////////////////////////////////////////////////
// An object ready for Drag-n-Drop
//////////////////////////////////////////////////////////////////////
@protocol CRDraggable<NSCoding>

+ (NSArray *)supportedDragTypes;
+ (void)writeObjects:(NSArray *)objects toPasteboard:(NSPasteboard *)pboard;
+ (BOOL)pasteboardContainsObjects:(NSPasteboard *)pboard;
+ (NSArray *)objectsFromPasteboard:(NSPasteboard *)pboard;

@end

//////////////////////////////////////////////////////////////////////
// CRViewDelegate
//////////////////////////////////////////////////////////////////////
@protocol CRViewDelegate
@optional
- (void)view:(CRView *)view mouseDown:(NSEvent *)event;
- (void)view:(CRView *)view mouseUp:(NSEvent *)event;
- (void)view:(CRView *)view mouseDragged:(NSEvent *)event;
- (void)view:(CRView *)view mouseEntered:(NSEvent *)event;
- (void)view:(CRView *)view mouseExited:(NSEvent *)event;

@end

//////////////////////////////////////////////////////////////////////
// CRLibraryItem
//////////////////////////////////////////////////////////////////////
@protocol CRLibraryItem<NSCoding, NSCopying>

@property (nonatomic, copy)		NSString*	name;			// item name
@property (nonatomic, copy)		NSString*	category;		// item category
@property (nonatomic, copy)		NSSet*		tags;			// item tags as an array of NSString
@property (nonatomic, assign)	BOOL		isSystem;		// flag, subj
@property (nonatomic, copy)		NSDate*		lastModified;	// last modification date

- (NSArray *)flushableProperties;
- (void)transferUserDataFromItem:(id<CRLibraryItem>)item;

@end

//////////////////////////////////////////////////////////////////////
// CRLibraryControllerProtocol
//////////////////////////////////////////////////////////////////////
@protocol CRLibraryControllerProtocol

- (CRLibraryManager *)library;

// Items manageent
- (void)addItem:(id)sender;
- (void)removeSelected:(id)sender;
- (void)addOrReplaceItem:(id)item;

@end